<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Alan Adı Durumu Kontrolü</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-2.1.1.min.js" type="text/javascript"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
    <style type="text/css">
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 20px;
            padding: 20px;
        }
        .domain-box {
            margin-top: 50px;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            background-color: #fff;
        }
        .extension-group {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 10px; /* Uzantılar arasındaki boşluğu ayarla */
            margin-top: 20px; /* Yükseklik ayarlandı */
        }
        .extension-item {
            width: 15%;
            margin-bottom: 10px;
            white-space: nowrap;
            text-align: center;
        }
        .btn-primary {
            margin-top: 10px;
            display: block;
            margin-left: auto;
            margin-right: auto;
        }
        h2, legend {
            text-align: center;
            margin-bottom: 20px;
        }
        .results-table {
            margin-top: 20px;
        }
        .punycode {
            color: green;
        }
        .extension-table {
            background-color: #800000; /* Kahve rengi arka plan */
            color: white; /* Beyaz yazı */
            font-weight: bold; /* Kalın yazı */
            margin-top: 20px;
            padding: 10px;
            border-radius: 8px;
        }
        .extension-table th {
            padding: 10px;
            font-size: 18px;
        }
        .extension-table td {
            padding: 10px;
            font-size: 16px;
            color: black; /* Yazı rengi siyah yapıldı */
        }
        .button-group {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-bottom: 20px; /* Add margin bottom to separate from extension group */
        }
        .button-group button {
            width: 200px; /* Button width increased for better readability */
        }
        .counters {
            text-align: center;
            margin-top: 20px;
        }
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5); /* Semi-transparent background */
            display: none; /* Initially hidden */
            justify-content: center;
            align-items: center;
            z-index: 1000; /* High z-index to ensure it's above other elements */
        }

        .loading-message {
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            text-align: center;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            font-size: 18px;
            font-weight: bold;
        }

        .domain-box {
            position: relative; /* Ensure the domain box is above the overlay */
            z-index: 1;
        }
    </style>
    
    <script>
        function highlightTable(tableId, isChecked) {
            var table = document.getElementById(tableId);
            if (isChecked) {
                table.style.backgroundColor = "#404040"; // Seçildiğinde arkaplan rengini değiştir
            } else {
                table.style.backgroundColor = ""; // Seçim kaldırıldığında arkaplan rengini temizle
            }
        }

        function convertToPunycode(domain) {
            try {
                return new URL('http://' + domain).hostname;
            } catch (e) {
                return domain;
            }
        }

        $(document).ready(function(){
            $('#turkishInput').on('input', function(){
                var turkishText = $(this).val();
                if (turkishText === '') {
                    $('#domain').val('');
                } else {
                    var domains = turkishText.split(' ');
                    var punycodeDomains = domains.map(function(domain) {
                        return convertToPunycode(domain);
                    });
                    $('#domain').val(punycodeDomains.join(' '));
                }
            });

            // Butonların işlevleri
            $('#allExtensions').click(function() {
                $('.extension-item').show();
            });

            $('#standardExtensions').click(function() {
                $('.extension-item').hide();
                $('.extension-item[data-ozel="0"]').show();
            });

            $('#supExtensions').click(function() {
                $('.extension-item').hide();
                $('.extension-item[data-ozel="1"]').show();
            });

            // Show initial items and handle "Daha Fazla" button
            const itemsToShow = 12; // Number of items to show initially
            const itemsIncrement = 10; // Number of items to add each time "Daha Fazla" is clicked
            let currentlyVisible = itemsToShow;

            function showMoreItems() {
                $('.extension-item').slice(0, currentlyVisible).show();
            }

            // Initially hide all items, then show the first `itemsToShow` items
            $('.extension-item').hide();
            showMoreItems();

            $('#loadMore').click(function() {
                currentlyVisible += itemsIncrement;
                showMoreItems();

                // Hide the button if all items are visible
                if ($('.extension-item:visible').length === $('.extension-item').length) {
                    $('#loadMore').hide();
                }
            });

            // Toggle all extension checkboxes based on "Tümünü Seç" checkbox
            $('#selectAll').change(function() {
                var isChecked = $(this).prop('checked');
                $('.extension-item input[type="checkbox"]').prop('checked', isChecked);
            });
        });
    </script>
</head>
<body>
<div class="container">
    <div class="domain-box">
        <h2>Alan Adı Durumu Kontrolü</h2>
        <form action="" method="post">
            <fieldset>
                <legend>Alan Adı Sorgula</legend>
                <div class="form-group">
                    <label for="domain">Alan Adı:</label>
                    <input type="text" class="form-control" id="domain" name="domain" placeholder="Her kelime seçili uzantılarda bulunur" required>
                    <input type="submit" class="btn btn-primary" name="check" value="Sorgula">
                </div>
                <fieldset>
                    <legend>Uygun Uzantıları Seçin:</legend>
                    <div class="button-group">
                        <?php
                        include 'baglan.php'; // Veritabanı bağlantı dosyasını dahil et

                        // Veritabanından tüm alan adı uzantılarını, fiyatlarını ve ozel değerlerini seç
                        $sql = "SELECT extension, price, ozel FROM domains";
                        $result = $conn->query($sql);

                        // Initialize counters
                        $totalExtensions = 0;
                        $standardExtensions = 0;
                        $supExtensions = 0;

                        // Eğer sonuçlar varsa, tabloları oluştur
                        if ($result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                $ext = $row['extension']; // Uzantıyı al
                                $price = $row['price'];   // Fiyatı al
                                $ozel = $row['ozel'];     // Özel sütun değerini al

                                // Uzantı türüne göre sayacı artır
                                $totalExtensions++;
                                if ($ozel == 0) {
                                    $standardExtensions++;
                                } elseif ($ozel == 1) {
                                    $supExtensions++;
                                }
                            }
                        } else {
                            echo "Uygun uzantı bulunamadı.";
                        }

                        $conn->close(); // Veritabanı bağlantısını kapat
                        ?>
                        <label for="selectAll">
                            <input type="checkbox" id="selectAll" name="selectAll" value="ON">
                            Tümünü Seç
                        </label>
                        <button type="button" class="btn btn-secondary" id="allExtensions">Tümü (<?php echo $totalExtensions; ?>)</button>
                        <button type="button" class="btn btn-secondary" id="standardExtensions">Standart (<?php echo $standardExtensions; ?>)</button>
                        <button type="button" class="btn btn-secondary" id="supExtensions">Özel (<?php echo $supExtensions; ?>)</button>
                    </div>
                    <div class="extension-group">
                        <?php
                        include 'baglan.php'; // Veritabanı bağlantı dosyasını tekrar dahil et

                        // Veritabanından tüm alan adı uzantılarını, fiyatlarını ve ozel değerlerini seç
                        $sql = "SELECT extension, price, ozel FROM domains";
                        $result = $conn->query($sql);

                        // Eğer sonuçlar varsa, tabloları oluştur
                        if ($result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                $ext = $row['extension']; // Uzantıyı al
                                $price = $row['price'];   // Fiyatı al
                                $ozel = $row['ozel'];     // Özel sütun değerini al

                                // Uzantıyı ve fiyatını uygun sınıf ve verilerle birlikte göster
                                echo "<div class='extension-item' data-ozel='$ozel' style='display: none;'>
                                <input type='checkbox' id='$ext' name='extensions[]' value='$ext'>
                                <label for='$ext'>$ext</label>
                                <span class='badge badge-info'>$price ₺</span>
                            </div>";
                            }
                        } else {
                            echo "Uygun uzantı bulunamadı.";
                        }

                        $conn->close(); // Veritabanı bağlantısını kapat
                        ?>
                    </div>
                    <div class="counters">
                        <p><span id="totalCounter">Toplam: <?php echo $totalExtensions; ?></span> |
                            <span id="standardCounter">Standart: <?php echo $standardExtensions; ?></span> |
                            <span id="supCounter">Özel: <?php echo $supExtensions; ?></span></p>
                    </div>
                    <div class="text-center">
                        <button type="button" class="btn btn-link" id="loadMore">Daha Fazla Göster</button>
                    </div>
                </fieldset>
            </fieldset>
        </form>

        <?php
        if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['check'])) {
            if (!empty($_POST['domain']) && !empty($_POST['extensions'])) {
                $domain_names = explode(' ', trim($_POST['domain']));
                $extensions = $_POST['extensions'];
                
                echo "<table class='table table-bordered results-table'>";
                echo "<thead><tr><th>Domain</th><th>Durum</th><th>Fiyat (₺)</th><th>İşlem</th></tr></thead>";
                echo "<tbody>";

                foreach ($domain_names as $domain_name) {
                    foreach ($extensions as $ext) {
                        $name_domain = $domain_name . $ext;
                        
                        $converted_domain = idn_to_ascii($name_domain);
                        $original_domain = idn_to_utf8($converted_domain);
                        
                        include 'baglan.php';

                        $stmt = $conn->prepare("SELECT price, harfadet FROM domains WHERE extension = ?");
                        $stmt->bind_param("s", $ext);
                        $stmt->execute();
                        $stmt->bind_result($price, $harfadet);
                        $stmt->fetch();
                        $stmt->close();
                        $conn->close();
                        
                        $status = (gethostbyname($converted_domain) != $converted_domain) ? 'Alınmış' : 'Mevcut';
                        
                        echo "<tr>";
                        if ($status == 'Alınmış') {
                            echo "<td><a href='http://$converted_domain' target='_blank'><span class='punycode'>$converted_domain</span> ($original_domain)</a></td>";
                        } else {
                            echo "<td><span class='punycode'>$converted_domain</span> ($original_domain)</td>";
                        }
                        echo "<td style='color:" . ($status == 'Alınmış' ? 'red' : 'green') . ";'>$status</td>";
                        
                        echo "<td>";
                        echo "<span style='font-size: 14px; color: gray;'>($harfadet)</span><br>";
                        echo "<span style='font-size: 18px; font-weight: bold;'>$price ₺</span>";
                        echo "</td>";
                        
                        echo "<td>";
                        if ($status == 'Mevcut') {
                            echo "<form action='siparis.php' method='post'>";
                            echo "<input type='hidden' name='domain' value='$name_domain'>";
                            echo "<input type='hidden' name='price' value='$price'>";
                            echo "<input type='submit' class='btn btn-success' value='Satın Al'>";
                            echo "</form>";
                        }
                        echo "</td>";
                        echo "</tr>";
                    }
                }

                echo "</tbody></table>";
            } else {
                echo "<div class='alert alert-danger mt-3'>Hata: Alan Adı girmeli ve en az bir uzantı seçmelisiniz.</div>";
            }
        }
        ?>
    </div>
</div>
</body>
</html>
