<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>UI Error Handling Example</title>
</head>
<body>
    <h1>UI Error Handling Demo</h1>
    <button id="fetchButton">Veriyi Getir</button>
    <div id="output"></div>

    <script>
        // Asenkron veri getirme fonksiyonu
        async function fetchData() {
            try {
                // Örnek bir API çağrısı (bu URL'yi test için kendi API'nizle değiştirin)
                const response = await fetch("https://jsonplaceholder.typicode.com/posts/1");
                
                if (!response.ok) {
                    throw new Error("API isteği başarısız oldu! HTTP Durum Kodu: " + response.status);
                }

                const data = await response.json();

                // `ui` nesnesini simüle ediyoruz
                const ui = data || null; // Veri yoksa `null` dönecek.

                // `type` kontrolü
                if (ui && ui.type) {
                    document.getElementById("output").innerText = "UI Type: " + ui.type;
                } else {
                    console.error("UI nesnesi geçersiz veya `type` özelliği mevcut değil:", ui);
                    document.getElementById("output").innerText = "Geçersiz UI nesnesi.";
                }
            } catch (error) {
                // Hata yakalama
                console.error("Hata oluştu:", error);
                document.getElementById("output").innerText = "Hata oluştu: " + error.message;
            }
        }

        // Buton tıklama olayını dinleme
        document.getElementById("fetchButton").addEventListener("click", () => {
            document.getElementById("output").innerText = "Veri getiriliyor...";
            fetchData();
        });
    </script>
</body>
</html>
