<?php
require_once "baglan.php"; // MySQL bağlantısını al

// Örnek olarak tanımlanan uzantılar
$allowedExtensions = array(".com", ".com.tr", ".net", ".org", ".edu");

// Fonksiyon tanımı
function domainCheck($domain, $extensions) {
    // Sonuçları saklamak için boş bir dizi oluştur
    $results = array();

    // Her uzantı için DNS kayıtlarını kontrol et
    foreach ($extensions as $ext) {
        $fullDomain = $domain . $ext;
        if (checkdnsrr($fullDomain, "ANY")) {
            $results[] = "<p>$fullDomain mevcut.</p>";
        } else {
            $results[] = "<p>$fullDomain mevcut değil.</p>";
        }
    }

    // Eğer hiç sonuç yoksa uygun mesajı ekle
    if (empty($results)) {
        $results[] = "<p>Alan adı sorgulanamadı.</p>";
    }

    // Sonuçları döndür
    return implode("\n", $results);
}

// Seçili uzantılar
$selectedExtensions = array();

// Form gönderildi mi kontrolü ve seçili uzantıları al
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $domain = $_POST["domain"];
    if (isset($_POST["extensions"])) {
        $selectedExtensions = $_POST["extensions"];
    }
}

?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Alan Adı Sorgulama</title>
</head>
<body>
    <h1>Alan Adı Sorgulama</h1>
    <form method="post" action="">
        <label for="domain">Alan Adı:</label>
        <input type="text" id="domain" name="domain" required>
        
        <fieldset>
            <legend>Uygun Uzantıları Seçin:</legend>
            <?php
            // Uygun uzantıları listelemek için döngü kullanın
            foreach ($allowedExtensions as $extension) {
                $checked = in_array($extension, $selectedExtensions) ? "checked" : "";
                echo "<input type='checkbox' id='$extension' name='extensions[]' value='$extension' $checked>";
                echo "<label for='$extension'>$extension</label><br>";
            }
            ?>
        </fieldset>
        
        <br>
        <button type="submit">Sorgula</button>
    </form>

    <?php
    // Form gönderildi mi kontrolü
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        // Seçili uzantılar ile alan adı sorgulama sonucunu ekrana yazdır
        if (!empty($selectedExtensions)) {
            echo "<h2>Sonuçlar:</h2>";
            echo domainCheck($domain, $selectedExtensions);
        }
    }
    ?>
</body>
</html>
