<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Alan Adı Siparişi</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 20px;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background-color: #fff;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        .package-card {
            margin-bottom: 20px;
            padding: 15px;
            border: 1px solid #ccc;
            border-radius: 8px;
            text-align: center;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Alan Adı Siparişi</h2>
    <?php
    if ($_SERVER["REQUEST_METHOD"] === "POST") {
        // Form verilerini al
        $domain = $_POST['domain'] ?? null;
        $price = $_POST['price'] ?? null;
        $selected_paket = $_POST['selected_paket'] ?? null;

        if ($domain && $price && $selected_paket) {
            // Paket ücretini al
            $selected_price = $_POST['selected_price_' . $selected_paket] ?? 0;

            // Toplam ücreti hesapla
            $total_price = $price + $selected_price;

            echo "<p><strong>Alan Adı:</strong> $domain</p>";
            echo "<p><strong>Temel Fiyat:</strong> $price ₺</p>";
            echo "<p><strong>Seçilen Paket ID:</strong> $selected_paket</p>";
            echo "<p><strong>Seçilen Paket Ücreti:</strong> $selected_price ₺</p>";
            echo "<p><strong>Toplam Ücret:</strong> <span style='font-size: 18px; font-weight: bold;'>$total_price ₺</span></p>";
        } else {
            echo "<p class='text-danger'>Hata: Eksik bilgi gönderildi. Lütfen tüm alanları doldurun.</p>";
        }
    } else {
        // Form gösterimi
        ?>
        <form action="" method="post">
            <div class="form-group">
                <label for="domain">Alan Adı:</label>
                <input type="text" class="form-control" id="domain" name="domain" required>
            </div>
            <div class="form-group">
                <label for="price">Temel Fiyat (₺):</label>
                <input type="number" class="form-control" id="price" name="price" required>
            </div>
            <h3>Paketler:</h3>
            <div class="row">
                <?php
                // Paketleri veritabanından getir
                include 'baglan.php';
                $sql = "SELECT Paket_id, PaketAdi, Ozellikler, ucret FROM Paket";
                $result = $conn->query($sql);

                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        $paketId = $row['Paket_id'];
                        $paketAdi = $row['PaketAdi'];
                        $ozellikler = $row['Ozellikler'];
                        $ucret = $row['ucret'];

                        echo "<div class='col-md-4'>";
                        echo "<div class='package-card'>";
                        echo "<h5>$paketAdi</h5>";
                        echo "<p><strong>Özellikler:</strong> $ozellikler</p>";
                        echo "<p><strong>Ücret:</strong> $ucret ₺</p>";
                        echo "<input type='radio' name='selected_paket' value='$paketId' required>";
                        echo "<input type='hidden' name='selected_price_$paketId' value='$ucret'>";
                        echo "</div>";
                        echo "</div>";
                    }
                } else {
                    echo "<div class='alert alert-danger'>Paket bulunamadı.</div>";
                }
                $conn->close();
                ?>
            </div>
            <button type="submit" class="btn btn-primary mt-3">Ödeme Yap</button>
        </form>
        <?php
    }
    ?>
</div>
</body>
</html>
