<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Alan Adı Siparişi</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 20px;
            padding: 20px;
        }
        .order-box {
            max-width: 800px;
            margin: 0 auto;
            background-color: #fff;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        .package-card {
            margin-bottom: 20px;
            padding: 15px;
            border: 1px solid #ccc;
            border-radius: 8px;
            text-align: center;
        }
        .btn-primary {
            display: block;
            margin: 20px auto;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="order-box">
        <h2>Alan Adı Siparişi Onay</h2>
        <?php
        if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['domain']) && isset($_POST['price'])) {
            $domain = $_POST['domain'];
            $price = $_POST['price'];
            echo "<p><strong>Alan Adı:</strong> $domain</p>";
            echo "<p><strong>Fiyat (TL):</strong> <span style='font-size: 18px; font-weight: bold;'>$price ₺</span></p>";
            echo "<p><strong>Paketler:</strong></p>";
            echo "<form action='odeme.php' method='post'>";
            echo "<input type='hidden' name='domain' value='$domain'>";
            echo "<input type='hidden' name='price' value='$price'>";
            echo "<div class='row'>";
            
            // Veritabanı bağlantısını yap
            include 'baglan.php';
            
            // Paket tablosundan verileri al
            $sql = "SELECT Paket_id, PaketAdi, Ozellikler, ucret FROM Paket";
            $result = $conn->query($sql);
            
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    $paketId = $row['Paket_id'];
                    $paketAdi = $row['PaketAdi'];
                    $ozellikler = $row['Ozellikler'];
                    $ucret = $row['ucret'];
                    
                    echo "<div class='col-lg-4 col-md-6 mb-3'>";
                    echo "<div class='package-card'>";
                    echo "<h5>$paketAdi</h5>";
                    echo "<p><strong>Özellikler:</strong> $ozellikler</p>";
                    echo "<p><strong>Ücret:</strong> <span style='font-size: 18px; font-weight: bold;'>$ucret ₺</span></p>";
                    echo "<button type='submit' class='btn btn-primary'<input type='radio' name='selected_paket' value='$paketId' required>Seç</button>";
                    echo "<input type='hidden' name='selected_price_$paketId' value='$ucret'>";
                    echo "</div>";
                    echo "</div>";
                }
            } else {
                echo "<div class='alert alert-danger'>Paket bulunamadı.</div>";
            }
            
            // Veritabanı bağlantısını kapat
            $conn->close();
            
            echo "</div>"; // .row bitiş
           
            echo "</form>"; // Form bitiş
        } else {
            echo "<p class='text-danger'>Hata: Geçersiz istek. Lütfen doğru bir sipariş sayfasından erişim sağlayın.</p>";
        }
        ?>
    </div>
</div>

</body>
</html>
