<?php
if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET['domain'])) {
    $domain = $_GET['domain'];
    $converted_domain = idn_to_ascii($domain);
    $original_domain = idn_to_utf8($converted_domain);

    $status = (gethostbyname($converted_domain) != $converted_domain) ? 'Alınmış' : 'Mevcut';

    echo "<!DOCTYPE html>";
    echo "<html lang='tr'>";
    echo "<head>";
    echo "<meta charset='UTF-8'>";
    echo "<title>Whois - $domain</title>";
    echo "<link rel='stylesheet' href='https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css'>";
    echo "<style>body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 20px; padding: 20px; }</style>";
    echo "</head>";
    echo "<body>";
    echo "<div class='container'>";
    echo "<h2>Whois Sonucu - $domain</h2>";
    echo "<p><strong>Alan Adı:</strong> <span class='punycode'>$converted_domain</span> ($original_domain)</p>";
    echo "<p><strong>Durum:</strong> <span style='color:" . ($status == 'Alınmış' ? 'red' : 'green') . ";'>$status</span></p>";

    if ($status == 'Alınmış') {
        // WHOIS bilgilerini almak için WHOIS sorgusu yapılacak
        $whois_result = shell_exec("whois $converted_domain");
        if ($whois_result) {
            echo "<h3>WHOIS Arama Sonuçları</h3>";

            // Kayıt başlama ve bitiş tarihlerini ayıklama
            preg_match('/Creation Date: (.+)/', $whois_result, $creation_date);
            preg_match('/Expiry Date: (.+)/', $whois_result, $expiry_date);

            echo "<p><strong>Kayıt Başlama Tarihi:</strong> " . ($creation_date[1] ?? 'Bilgi bulunamadı') . "</p>";
            echo "<p><strong>Kayıt Bitiş Tarihi:</strong> " . ($expiry_date[1] ?? 'Bilgi bulunamadı') . "</p>";
            
            echo "<pre>$whois_result</pre>";
        } else {
            echo "<p>WHOIS bilgisi bulunamadı.</p>";
        }
        echo "<p><a href='http://$converted_domain' target='_blank'>Siteye Git</a></p>";
    } else {
        echo "<p>Alan adı mevcut olduğu için WHOIS bilgisi yok.</p>";
    }

    echo "</div>";
    echo "</body>";
    echo "</html>";
} else {
    header("Location: whois.php");
    exit();
}
?>
